--
-- testInsert.sql
--
CREATE OR REPLACE PROCEDURE testInsert( p_xmlDoc IN CLOB )
IS
  v_insCtx  DBMS_XMLSave.ctxType;
  v_rows    NUMBER;
BEGIN
  v_insCtx := DBMS_XMLSave.newContext('hr.employees'); -- get the save context

  DBMS_XMLSave.clearUpdateColumnList(v_insCtx); -- clear the update settings

  -- set the columns to be used in the INSERT as a list of values
  DBMS_XMLSave.setUpdateColumn(v_insCtx,'EMPLOYEE_ID'); 
  DBMS_XMLSave.setUpdateColumn(v_insCtx,'LAST_NAME');
  DBMS_XMLSave.setUpdateColumn(v_insCtx,'EMAIL');
  DBMS_XMLSave.setUpdatecolumn(v_insCtx,'JOB_ID');
  DBMS_XMLSave.setUpdateColumn(v_insCtx,'HIRE_DATE');

  -- Insert the doc. This procedure only inserts into EMPLOYEE_ID, LAST_NAME,
  -- EMAIL, JOB_ID, and HIRE_DATE columns; the rest are treated as NULL
  v_rows := DBMS_XMLSave.insertXML(v_insCtx, p_xmlDoc); 
  DBMS_XMLSave.closeContext(v_insCtx);
END;
/
